package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Request;

/**
 * Class OperationalDocumentRuleEvaluator.
 *
 */
public class OperationalDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {

    @Override
    public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Location site,
            final boolean isIndependentOnly) {
        return false;
    }

    @Override
    public boolean isRequired(final Request request, final DataSource dataSource, final DocumentTemplate documentTemplate,
            final Participant participant, final boolean isIndependentOnly) {

        // NDS Health Form is required of all participants
        if (request == null || isPreparatoryRequest(request)) {
            return false;
        }

        if (documentTemplate.getName().startsWith("VHA NDS Health Operations")) {
            return true;
        }

        return false;
    }

    @Override
    public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Group admin,
            final Location site, final boolean isIndependentOnly) {
        return false;
    }

    @Override
    public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Group admin,
            final Participant participant, final boolean isIndependentOnly) {
        return false;
    }
}
